﻿Partial Public Class SecondPage
    Inherits PhoneApplicationPage
    Private rand As New Random()


    Public Sub New()
        InitializeComponent()
    End Sub


    Private Sub OnTextBlockManipulationStarted(ByVal sender As Object,
                                               ByVal args As ManipulationStartedEventArgs)
        Me.NavigationService.GoBack()

        args.Complete()
        args.Handled = True
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        ContentPanel.Background = New SolidColorBrush(Color.FromArgb(255, CByte(rand.Next(255)),
                                                                          CByte(rand.Next(255)),
                                                                          CByte(rand.Next(255))))

        MyBase.OnManipulationStarted(args)
    End Sub


    Protected Overrides Sub OnNavigatedFrom(ByVal args As NavigationEventArgs)
        If TypeOf ContentPanel.Background Is SolidColorBrush Then
            Dim clr = (TryCast(ContentPanel.Background, SolidColorBrush)).Color

            If TypeOf args.Content Is MainPage Then
                TryCast(args.Content, MainPage).ReturnedColor = clr
            End If

            ' Save color
            PhoneApplicationService.Current.State("Color") = clr
        End If

        MyBase.OnNavigatedFrom(args)
    End Sub


    Protected Overrides Sub OnNavigatedTo(ByVal args As NavigationEventArgs)
        ' Retrieve color
        If PhoneApplicationService.Current.State.ContainsKey("Color") Then
            Dim clr = CType(PhoneApplicationService.Current.State("Color"), Color)
            ContentPanel.Background = New SolidColorBrush(clr)
        End If

        MyBase.OnNavigatedTo(args)
    End Sub
End Class
